<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>IBSheet7-Product</title>

	<script type="text/javascript" src="../js/common.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts-more.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/funnel.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/boost.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	<script type="text/javascript" src="./chartTypeOptions.js"></script>

	<script type="text/javascript" src="https://unpkg.com/canvg@3.0.4/lib/umd.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			createIBChart("pieChart", "pieChart", {
				width: "100%",
				height: "85%"
			});

			pieChartDraw();
		});

		function pieChartDraw()
		{
			var Type = $("#pieCombo").val();
			pieChart.removeAll();
			pieChart.setOptions(pieChartOption,{
				deepCopy: true
			});
			switch(Type)
			{
				case "PIE":
				doSearch(pieChart,"chartdata_pie.json");
				break;

				case "PIE_InnerSize":
				pieChart.setOptions({
					plotOptions: {
						pie:{
							innerSize:100
						}
					}
				},{
					append : true
				});
				doSearch(pieChart,"chartdata_pie.json");
				break;

				case "PIE_Donut":
				pieChart.setOptions({
					plotOptions: {
						pie: {
							shadow: false,
							center: ['50%', '50%'],
							showInLegend: true
						}
					},
					tooltip: {
						valueSuffix: '명'
					},
					legend:{
						enabled:false
					},
					series:[
					{
						name:"전체인원",
						size: '25%',
						dataLabels: {
							formatter: function () {
								return this.point.name;
							},
							color: '#FFFFFF',
							distance: -30
						},
						data:[
						{name: "부산광역시",y:3393191,color:"#0072ff"},
						{name:"대구광역시",y:2431774,color:"#f83600"},
						{name:"인천광역시",y:2632035,color:"#71B280"},
						{name:"광주광역시",y:1466143,color:"#e9d882"},
						{name:"대전광역시",y:1490158,color:"#6E48AA"},
						{name:"울산광역시",y:1071673,color:"#BB377D"}
						]
					}, {
						name:"인원",
						size: '80%',
						innerSize: '50%',
						dataLabels: {
							formatter: function () {
								return this.point.name;
							},
							color: '#343434',
							distance: -15
						},
						data:[
						{name:"남자",y:1664678,color:"#00c6ff"},
						{name:"여자",y:1728513,color:"#00c6ff"},
						{name:"남자",y:1204428,color:"#fe8c00"},
						{name:"여자",y:1227346,color:"#fe8c00"},
						{name:"남자",y:1315562,color:"#E3F6CE"},
						{name:"여자",y:1316473,color:"#E3F6CE"},
						{name:"남자",y:724161,color:"#EAEADE"},
						{name:"여자",y:741982,color:"#EAEADE"},
						{name:"남자",y:745150,color:"#BD70DB"},
						{name:"여자",y:745008,color:"#BD70DB"},
						{name:"남자",y:550869,color:"#FBD3E9"},
						{name:"여자",y:520804,color:"#FBD3E9"}
						]
					}
					]
				},{
					append : true,
					redraw : true
				});
				break;
				case "Half_Donut":
				pieChart.setOptions({
					title: {
						text: '광역시<br>인구분포',
						align: 'center',
						verticalAlign: 'middle',
						y: 45,
						x:-60
					},
					colors : [{
						linearGradient: {x1: 0, x2: 0, y1: 1, y2: 0},
						stops: [[0, '#0072ff'],[1, '#00c6ff']]
					},{
						linearGradient: {x1: 0, x2: 0, y1: 1, y2: 0},
						stops: [[0, '#f83600'],[1, '#fe8c00']]
					},{
						linearGradient: {x1: 0, x2: 0, y1: 1, y2: 0},
						stops: [[0, '#71B280'],[1, '#E3F6CE']]
					},{
						linearGradient: {x1: 0, x2: 0, y1: 1, y2: 0},
						stops: [[0, '#e9d362'],[1, '#FFEAEE']]
					},{
						linearGradient: {x1: 0, x2: 0, y1: 1, y2: 0},
						stops: [[0, '#6E48AA'],[1, '#BD70DB']]
					},{
						linearGradient: {x1: 0, x2: 0, y1: 1, y2: 0},
						stops: [[0, '#BB377D'],[1, '#FBD3E9']]
					}],
					plotOptions: {
						pie: {
							dataLabels: {
								enabled: true,
								style: {
									fontWeight: 'bold',
									textShadow: '0px 1px 2px black',
									depth: 35
								},
								formatter:function(){
									return this.point.name+":"+ (this.y).toLocaleString()+"명";
								}
							},
							startAngle: -90,
							endAngle: 90,
							center: ['50%', '75%'],
							showInLegend: true
						}
					},
					series: [{
						name: '인구수',
						innerSize: '50%',
						data: [
						{name: "부산광역시",y:3393191},
						{name:"대구광역시",y:2431774},
						{name:"인천광역시",y:2632035},
						{name:"광주광역시",y:1466143},
						{name:"대전광역시",y:1490158},
						{name:"울산광역시",y:1071673}
						]
					}]
				},{
					append : true,
					redraw : true
				});
				break;
			}
			// pie3dUse(document.getElementById("pieCheck").checked);
		}

		function Down2Image(Type){
			switch (Type)
			{
				case "PNG":
					//chart객체, 파일명
					downChart2Image(pieChart,"파이차트.png");
				break;
			}
		}

		function doSearch(chart,url,subparam){
			$.ajax({
				type: 'post'
				, async: true
				, dataType:"text"
				, url: url
				, data:  subparam
				, beforeSend: function() {

				}
				, success: function(JSON) {
					chart.loadSearchData(JSON, {
						append: true
					});
				}
				, error: function(data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				}
				,complete:function(jqXHR,textStatus){

				}
			});
		}

		function pie3dUse(chk){
			if(document.getElementById("pieCombo").value=="PIE_Donut"||document.getElementById("pieCombo").value=="Half_Donut"){
				document.getElementById("pieCheck").checked = false;
				return;
			}
			if(chk){
				pieChart.setOptions({
					chart: {
						options3d: {
							enabled : true,
							alpha : 45,
							beta:0

						}
					}
				},{
					append : true
				});

			}else{
				pieChart.setOptions({
					chart: {
						options3d: {
							enabled : false
						}
					}
				},{
					append : true
				});
			}
			pieChart.draw();
		}

		function DoPrint(){
			pieChart.doPrint();
		}
	</script>

</head>
<body>
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 유형 > <b>파이형 타입</b></span>
	</div>
	<div class="main_content">
		<div style="float:left;width:100%">
			<div class="exp_product" style="float:left;width:30%">
				파이형 차트를 확인합니다.
			</div>
			<div class="ib_function" style="float:left;width:70%;text-align:right">
				<a href="javascript:Down2Image('PNG')" class="f1_btn_white gray">이미지 다운로드</a>
				<a href="javascript:DoPrint()" class="f1_btn_white gray">이미지 프린트</a>
			</div>
		</div>
		<div class="clear hidden"></div>

		<p class="subtit_chart">차트 유형</p>
		<div class="ib_chart_product">
			<span class="chartCombo">
				<select class="chartCombo" id="pieCombo" onchange="pieChartDraw()">
					<option value="PIE" >파이</option>
					<option value="PIE_InnerSize" >도넛</option>
					<option value="PIE_Donut" >파이+도넛</option>
					<option value="Half_Donut" >반원 도넛</option>
				</select>
				<!-- 3D 사용 : <input type="checkbox" id="pieCheck" onchange="pie3dUse(this.checked)"> -->
			</span>
			<div style="height:10px"></div>
			<div id="pieChart"></div>
		</div>
		<!--main_content-->
	</body>
</html>